﻿<?LassoScript
	/*
			See if this user is logged in
	*/
	var('isLoggedIn' = admin_currentusername != 'ANONYMOUS' && admin_currentusername->size > 0);
	/*
			Are we trying to authenticate?
	*/
	if (!$isLoggedIn && action_param('auth')->size > 0);
		// this will cause the authentication dialog to come up if the user is not yet logged in
		auth;
	/if;
	
	/*
			Initialize the database and tables which are required for the blog. 
		The database stucture is as  follows:
		op_blog
			entries
				id
				author - the author's name
				date - the date the entry was posted
				title - the title of the entry
				body - the entry's body text
				(trigger to delete all comments when removed)
			comments
				id
				id_entry - the id of the entry the comment is attached to
				author - the comment author's name
				date - the date the comment was added
				body - the body text of the comment
	*/
	local('initializeResults' = Application_initialize(
												Application_appInfo->title, 
												Application_appInfo->version, 
												array(
			-database= pair('op_blog' = array(
				-group = pair('ANYUSER'='I,S,A,U,D,X'),
				-table = pair('blogs' = array(
					-sql = 'CREATE TABLE blogs (	id INTEGER PRIMARY KEY,
												author TEXT,
												title TEXT,
												description TEXT)',
					-sql = 'CREATE INDEX blogs_author_index ON blog (author)',
					-group = pair('ANYUSER'='I,S,A,U,D,X')
					)),
				-table = pair('entries' = array(
					-sql = 'CREATE TABLE entries (	id INTEGER PRIMARY KEY,
													id_blog INTEGER,
													date TEXT DEFAULT CURRENT_TIMESTAMP,
													title TEXT,
													body TEXT)',
					-sql = 'CREATE INDEX entries_id_blog_index ON entries (id_blog)',
					-sql = 'CREATE INDEX entries_title_index ON entries (title)',
					-sql = 'CREATE INDEX entries_body_index ON entries (body)',
					-group = pair('ANYUSER'='I,S,A,U,D,X')
					)),
				-table = pair('comments' = array(
					-sql = 'CREATE TABLE comments (	id INTEGER PRIMARY KEY,
													id_entry INTEGER,
													author TEXT,
													date TEXT DEFAULT CURRENT_TIMESTAMP,
													body TEXT)',
					-sql = 'CREATE INDEX comments_id_entry_index ON comments (id_entry)',
					-group = pair('ANYUSER'='I,S,A,U,D,X')
					))
				))
			)));
	
	// if the application was just now initialized, add a starter blog and blog entry
	if (#initializeResults->size);
		inline(-database='op_blog');
			inline(-table='blogs', -findall);
				if (found_count == 0);
					inline(-sql="INSERT INTO blogs (id, author, title, description) VALUES (1, '"admin_currentusername"', \'A Starter Blog\', \'This blog was automatically generated for you.\');"
								"INSERT INTO entries (id_blog, title, body) VALUES (1, 'Welcome!', '\
									Welcome to the Lasso Blog!\r\n\
									Your new blog was successfully initialized.');");/inline;
				/if;
			/inline;
		/inline;
	/if;											
												
												
												
												
												
												
												
												
?>